function _cameraMover() {
    this.needsredraw = true;
    this.rotationCenter = new THREE.Vector4();
    this.matrix = new THREE.Matrix4();
    this.distance = 600;
    this.pan = new THREE.Vector4();

    this.rotateAnimation = false;
    this.rotmat = new THREE.Matrix4();

    this.getAndResetUpdateFlag = function () {
      if (this.rotateAnimation) {
        return this.rotateAnimation;
      }
      var n = this.needsredraw;
      this.needsredraw = false;
      return n;
    };

    this.updateCamera = function (camera, sphereRadius) {
      if (this.rotateAnimation === true) {
        this.matrix.multiplyMatrices(this.rotmat, this.matrix);
      }
      //var l=(new THREE.Vector4(this.camera.position.x,this.camera.position.y,this.camera.position.z,1)).length();
      var matrix_inverse = new THREE.Matrix4(),
        matrix_cam_to_root = new THREE.Matrix4(),
        matrix_rotationcenter = new THREE.Matrix4();
      matrix_rotationcenter.makeTranslation(-this.rotationCenter.x, -this.rotationCenter.y, -this.rotationCenter.z);
      matrix_cam_to_root.multiplyMatrices(this.matrix, matrix_rotationcenter);
      matrix_cam_to_root.elements[3 * 4 + 2] += -this.distance; // add distance to Matrix
      matrix_cam_to_root.elements[3 * 4] += this.pan.x;
      matrix_cam_to_root.elements[3 * 4 + 1] += this.pan.y; // add distance to Matrix
      matrix_inverse.getInverse(matrix_cam_to_root);
      camera.matrix.copy(new THREE.Matrix4()); // reset couse applyMatrix always multiply with this 
      camera.applyMatrix(matrix_inverse);
      camera.updateMatrix();
      var minNear = sphereRadius / 50;
      camera.near = Math.max(minNear, this.distance - sphereRadius);
      camera.far = this.distance + sphereRadius;
      camera.updateProjectionMatrix();
      return this.getAndResetUpdateFlag();
    };

    this.animationRotate3DPreview = function () {
      this.rotateAnimation = true;
      this.rotmat.makeRotationY(Math.PI / 180.0);
      this.needsredraw = true;
    };
    this.setRoatationMatrix = function (m) {
      this.matrix = m;
      this.needsredraw = true;
    };

    this.getCameraParams = function () {
      var _this = this;
      var fovy = 35.0;
      var frustum_width = 0;
      var frustum_height = 0;
      var euler = new THREE.Euler();
      var rmat = new THREE.Matrix4();
      rmat.copy(this.matrix);
      euler.setFromRotationMatrix(rmat, 'ZYX');
      var Rotation = {
        roll: -euler.x / Math.PI * 180.0,
        pitch: euler.y / Math.PI * 180.0,
        yaw: -euler.z / Math.PI * 180.0
      };
      return {
        camera: 'perpective',
        rotation: Rotation,
        rotation_center: {
          x: _this.rotationCenter.x,
          y: _this.rotationCenter.y,
          z: _this.rotationCenter.z
        },
        focal_length: -_this.distance,
        pan: {
          x: _this.pan.x,
          y: _this.pan.y
        },
        frustum: {
          width: frustum_width,
          height: frustum_height
        }
      };
    };
    this.setCameraParams = function (param) {
      var euler = new THREE.Euler(-param.rotation.roll * Math.PI / 180.0, param.rotation.pitch * Math.PI / 180.0, -param.rotation.yaw * Math.PI / 180.0, 'ZYX');
      this.matrix.makeRotationFromEuler(euler);
      // rotation center
      this.rotationCenter.x = param.rotation_center.x;
      this.rotationCenter.y = param.rotation_center.y;
      this.rotationCenter.z = param.rotation_center.z;
      // focal_length
      this.distance = -param.focal_length;
      //pan 
      this.pan.x = param.pan.x;
      this.pan.y = param.pan.y;

      this.needsredraw = true;
      // TODO adjust pan and focal_length on frustum
    };

  }
  //-----------------------------------------------------------------------
  //-----------------------------------------------------------------------
  function _cameraMoverControl(viewer, domElement) {
    var _this = this;
    var STATE = {
      NONE: -1,
      ROTATE: 0,
      ZOOM: 2,
      PAN: 1,
      TOUCH_ROTATE: 3,
      TOUCH_ZOOM: 4,
      TOUCH_PAN: 5
    };

    this.__cameraMover = viewer.__cameraMover;
    this.camera = viewer.camera;
    this.viewer = viewer;
    this.domElement = (domElement !== undefined) ? domElement : document;
    this.enabled = true;
    this.screen = {
      left: 0,
      top: 0,
      width: 0,
      height: 0
    };
    this.toolTipStartPos = new THREE.Vector2();
    this.toolTipStartPosTime = -1;
    var _state = STATE.NONE;
    var _prevState = STATE.NONE;
    var _projector = new THREE.Projector();
    // events
    var changeEvent = {
      type: 'change'
    };
    var startEvent = {
      type: 'start'
    };
    var endEvent = {
      type: 'end'
    };
    //
    var _pxLast = new THREE.Vector2();
    var _pxDown = new THREE.Vector2();
    var _mouseMoved = false;
    var _pageLast = new THREE.Vector2();
    //-----------------------------------------------------------------------
    this.handleResize = function () {
      if (this.domElement === document) {

        this.screen.left = 0;
        this.screen.top = 0;
        this.screen.width = window.innerWidth;
        this.screen.height = window.innerHeight;

      } else {

        var box = this.domElement.getBoundingClientRect();
        // adjustments come from similar code in the jquery offset() function
        var d = this.domElement.ownerDocument.documentElement;
        this.screen.left = box.left + window.pageXOffset - d.clientLeft;
        this.screen.top = box.top + window.pageYOffset - d.clientTop;
        this.screen.width = box.width;
        this.screen.height = box.height;
      }
      _cameraMover.needsredraw = true;
    };
    //-----------------------------------------------------------------------
    this.handleEvent = function (event) {
      if (typeof this[event.type] === 'function') {
        this[event.type](event);
      }
    };
    //-----------------------------------------------------------------------
    this.getMouseOnScreen = function (pageX, pageY, vector) {
      var isw = 1.0 / _this.screen.width;
      var ish = 1.0 / _this.screen.height;
      return vector.set((pageX - _this.screen.left) * isw, (pageY - _this.screen.top) * ish);
    };
    //-----------------------------------------------------------------------
    function keydown(event) {

      /*	if ( _this.enabled === false ) return;

		window.removeEventListener( 'keydown', keydown );

		_prevState = _state;

		if ( _state !== STATE.NONE ) {

			return;

		} else if ( event.keyCode === _this.keys[ STATE.ROTATE ] && !_this.noRotate ) {

			_state = STATE.ROTATE;

		} else if ( event.keyCode === _this.keys[ STATE.ZOOM ] && !_this.noZoom ) {

			_state = STATE.ZOOM;

		} else if ( event.keyCode === _this.keys[ STATE.PAN ] && !_this.noPan ) {

			_state = STATE.PAN;

		}
*/
    }

    function keyup(event) {

      /*	if ( _this.enabled === false ) return;

		_state = _prevState;

		window.addEventListener( 'keydown', keydown, false );
*/
    }
    this.onLClickObject = function (event, hitinfo) {
      if ( viewer.signals !== undefined  ){
        return viewer.signals.onLClickObject(event, hitinfo);
      }else{
        return false;
      }
    };
    this.onContextMenuObject = function (event, hitinfo) {
      if ( viewer.signals !== undefined  ){
        return viewer.signals.onContextMenuObject(event, hitinfo);
      }
      else{
        return false;
      }
    };
    this.onClickObject = function (event, hitinfo) {
      //if (hitinfo.object.drawType === 'face') {
      //alert(hitinfo.object.geometry.cnsName);
      var cont=true;
      if ( hitinfo !== undefined )      {
         cont=hitinfo.object.visible ;
      }
      if (cont === true) {
        //        hitinfo.object.visible = false;
        if (event.button === 2) {
          // context menu
          return this.onContextMenuObject(event, hitinfo);
        } else {
          return this.onLClickObject(event, hitinfo);
        }
      }
      //hitinfo.object.translateX(100);
      //hitinfo.object.position.y += 100;
      //INTERSECTED.currentHex = INTERSECTED.material.emissive.getHex();
      //hitinfo.object.material.emissive.setHex(0xff0000);

      //}

      //}
      return false;
    };
    this.onClickEvent = function (event) {     
    };


    function mousemove(event) {

      if (_this.enabled === false) {
        return;
      }

      event.preventDefault();
      event.stopPropagation();
      var pxNow = new THREE.Vector2(),
        m = new THREE.Matrix4(),
        dx = 0,
        dy = 0;
      _this.getMouseOnScreen(event.pageX, event.pageY, pxNow);
      /*    _this.onClickEvent(event);
      return;*/
      if (_mouseMoved === false && Math.abs(pxNow.x - _pxDown.x) < 0.01 && Math.abs(pxNow.y - _pxDown.y) < 0.01) {
        return;
      }
      _mouseMoved = true;
      if (_state === STATE.ROTATE) {
        dy = pxNow.y - _pxLast.y;
        dx = pxNow.x - _pxLast.x;
        dx *= Math.PI * 2.0;
        dy *= Math.PI * 2.0;
        m.makeRotationFromEuler(new THREE.Euler(dy, dx, 0, 'XYZ'));
        var matrix_new = new THREE.Matrix4();
        matrix_new.multiplyMatrices(m, _cameraMover.matrix);
        _cameraMover.setRoatationMatrix(matrix_new);
        _pxLast = pxNow;
        _cameraMover.needsredraw = true;
      }
      if (_state === STATE.PAN) {
        dy = pxNow.y - _pxLast.y;
        dx = pxNow.x - _pxLast.x;
        var z = _cameraMover.distance;
        var focallengthx = Math.tan(camera.fov / 180.0 * Math.PI / 2);
        var f = z / focallengthx;
        dx *= f;
        dy *= f;
        _cameraMover.pan.x += dx;
        _cameraMover.pan.y -= dy;
        _pxLast = pxNow;
        _cameraMover.needsredraw = true;
      }
      if (_state === STATE.ZOOM) {

        dy = pxNow.y - _pxLast.y;
        _cameraMover.distance *= 1.0 + dy;
        _pxLast = pxNow;
        _cameraMover.needsredraw = true;
      }
      if (_state === STATE.NONE) {
        if (Math.abs(_this.toolTipStartPos.x - pxNow.x) > 5 || Math.abs(_this.toolTipStartPos.y - pxNow.y) > 5) {
          _this.toolTipStartPos = pxNow;
          // reset timer
          if (window.performance.now) {
            _this.toolTipStartPosTime = window.performance.now();
          } else {
            _this.toolTipStartPosTime = Date.now();
          }
        }
      }
    }

    function mouseup(event) {


      if (_this.enabled === false) {
        return;
      }

      event.preventDefault();
      event.stopPropagation();

      if (_mouseMoved === false) {
        _this.onClickEvent(event);
        _cameraMover.needsredraw = true;
        document.removeEventListener('mousemove', mousemove);
        document.removeEventListener('mouseup', mouseup);
        _state = STATE.NONE;
        return;
      }

      if (_state === STATE.PAN) {
        _this.getMouseOnScreen(event.pageX, event.pageY, _pxLast);
        if (event.button === 0) {
          _state = STATE.ZOOM;

        } else {
          _state = STATE.ROTATE;
        }
      } else {
        _state = STATE.NONE;
        document.removeEventListener('mousemove', mousemove);
        document.removeEventListener('mouseup', mouseup);
        _this.dispatchEvent(endEvent);
      }
      _cameraMover.needsredraw = true;
    }

    function mousedown(event) {

      if (_this.enabled === false) {
        return;
      }

      event.preventDefault();
      event.stopPropagation();

      if (event.button === 0 || event.button === 2) {
        _pageLast.x = event.pageX;
        _pageLast.y = event.pageY;
        _this.getMouseOnScreen(event.pageX, event.pageY, _pxLast);
        _pxDown.x = _pxLast.x;
        _pxDown.y = _pxLast.y;
        _mouseMoved = false;
        document.addEventListener('mousemove', mousemove, false);
        document.addEventListener('mouseup', mouseup, false);
        _this.dispatchEvent(startEvent);
        if (event.button === 0) {
          if (_state === STATE.ZOOM) {
            _state = STATE.PAN;
          } else {
            _state = STATE.ROTATE;
          }
        } else if (event.button === 2) {
          if (_state === STATE.ROTATE) {
            _state = STATE.PAN;
          } else {
            _state = STATE.ZOOM;
          }
        }

      }
    }



    function mousewheel(event) {
      if (_this.enabled === false) {
        return;
      }

      event.preventDefault();
      event.stopPropagation();

      var delta = 0;

      if (event.wheelDelta) { // WebKit / Opera / Explorer 9

        delta = event.wheelDelta / 40;

      } else if (event.detail) { // Firefox

        delta = -event.detail / 3;

      }

      _cameraMover.distance *= 1.0 + delta / 30;
      _this.dispatchEvent(startEvent);
      _this.dispatchEvent(endEvent);
      _cameraMover.needsredraw = true;

    }

    function touchstart(event) {

      /*	if ( _this.enabled === false ) return;

		switch ( event.touches.length ) {

			case 1:
				_state = STATE.TOUCH_ROTATE;
				_rotateEnd.copy( _this.getMouseProjectionOnBall( event.touches[ 0 ].pageX, event.touches[ 0 ].pageY, _rotateStart ));
				break;

			case 2:
				_state = STATE.TOUCH_ZOOM;
				var dx = event.touches[ 0 ].pageX - event.touches[ 1 ].pageX;
				var dy = event.touches[ 0 ].pageY - event.touches[ 1 ].pageY;
				_touchZoomDistanceEnd = _touchZoomDistanceStart = Math.sqrt( dx * dx + dy * dy );
				break;

			case 3:
				_state = STATE.TOUCH_PAN;
				_panEnd.copy( _this.getMouseOnScreen( event.touches[ 0 ].pageX, event.touches[ 0 ].pageY, _panStart ));
				break;

			default:
				_state = STATE.NONE;

		}
		_this.dispatchEvent( startEvent );
*/
      _cameraMover.needsredraw = true;

    }

    function touchmove(event) {

      /*	if ( _this.enabled === false ) return;

		event.preventDefault();
		event.stopPropagation();

		switch ( event.touches.length ) {

			case 1:
				_this.getMouseProjectionOnBall( event.touches[ 0 ].pageX, event.touches[ 0 ].pageY, _rotateEnd );
				break;

			case 2:
				var dx = event.touches[ 0 ].pageX - event.touches[ 1 ].pageX;
				var dy = event.touches[ 0 ].pageY - event.touches[ 1 ].pageY;
				_touchZoomDistanceEnd = Math.sqrt( dx * dx + dy * dy )
				break;

			case 3:
				_this.getMouseOnScreen( event.touches[ 0 ].pageX, event.touches[ 0 ].pageY, _panEnd );
				break;

			default:
				_state = STATE.NONE;

		}*/
      _cameraMover.needsredraw = true;

    }

    function touchend(event) {

      /*	if ( _this.enabled === false ) return;

		switch ( event.touches.length ) {

			case 1:
				_rotateStart.copy( _this.getMouseProjectionOnBall( event.touches[ 0 ].pageX, event.touches[ 0 ].pageY, _rotateEnd ));
				break;

			case 2:
				_touchZoomDistanceStart = _touchZoomDistanceEnd = 0;
				break;

			case 3:
				_panStart.copy( _this.getMouseOnScreen( event.touches[ 0 ].pageX, event.touches[ 0 ].pageY, _panEnd ));
				break;

		}

		_state = STATE.NONE;
		_this.dispatchEvent( endEvent );
    */
      _cameraMover.needsredraw = true;

    }

    this.update = function () {

    };

    this.domElement.addEventListener('contextmenu', function (event) {
      event.preventDefault();
    }, false);

    this.domElement.addEventListener('mousedown', mousedown, false);

    this.domElement.addEventListener('mousewheel', mousewheel, false);
    this.domElement.addEventListener('DOMMouseScroll', mousewheel, false); // firefox

    this.domElement.addEventListener('touchstart', touchstart, false);
    this.domElement.addEventListener('touchend', touchend, false);
    this.domElement.addEventListener('touchmove', touchmove, false);

    window.addEventListener('keydown', keydown, false);
    window.addEventListener('keyup', keyup, false);

    this.handleResize();

    // force an update at start
    this.update();

  }

  _cameraMoverControl.prototype = Object.create(THREE.EventDispatcher.prototype);