(function(window, jQ) {
  var psol = window.psol = window.psol || {};
  psol.core = function() {
    var _serviceBaseUrl = window.location.protocol + "//" + window.location.host;
    var _language = "english";
    var _languages = [];
    var _global_http_headers = {};
    var _global_http_parameters = {};
    function setServiceBaseUrl(serviceBaseUrl) {
      _serviceBaseUrl = serviceBaseUrl
    }
    function getServiceBaseUrl() {
      return _serviceBaseUrl
    }
    function getLanguage() {
      return _language
    }
    function setLanguage(lang) {
      _language = lang;
      if(hasLocalStorageSupport()) {
        localStorage.language = lang
      }
    }
    function getLanguageByShortIso(shortIso) {
      if(shortIso === null || shortIso === "") {
        return null
      }
      var i = 0;
      for(i = 0;i < _languages.length;++i) {
        if(_languages[i].short_iso === shortIso) {
          return _languages[i]
        }
      }
      return null
    }
    function getLanguageByLongIso(longIso) {
      if(longIso === null || longIso === "") {
        return null
      }
      var i = 0;
      for(i = 0;i < _languages.length;++i) {
        if(_languages[i].long_iso === longIso) {
          return _languages[i]
        }
      }
      return null
    }
    function getLanguageByLanguage(lang) {
      if(lang === null || lang === "") {
        return null
      }
      var i;
      for(i = 0;i < _languages.length;++i) {
        if(_languages[i].language === lang) {
          return _languages[i]
        }
      }
      return null
    }
    function getShortIsoByLanguage(language) {
      if(language === null || language === "") {
        return null
      }
      var i;
      for(i = 0;i < _languages.length;++i) {
        if(_languages[i].language === language) {
          return _languages[i].short_iso
        }
      }
      return null
    }
    function getLongIsoByLanguage(language) {
      if(language === null || language === "") {
        return null
      }
      var i = 0;
      for(i = 0;i < _languages.length;++i) {
        if(_languages[i].language === language) {
          return _languages[i].long_iso
        }
      }
      return null
    }
    function getBrowserLocale() {
      var locale = null;
      if(!navigator) {
        return locale
      }
      locale = navigator.browserLanguage;
      if(!locale || locale.length < 2) {
        locale = navigator.language
      }
      if(!locale || locale.length < 2) {
        locale = navigator.userLanguage
      }
      if(!locale || locale.length < 2) {
        locale = navigator.systemLanguage
      }
      return locale
    }
    function getBrowserLocaleLongIso() {
      var locale = getBrowserLocale();
      if(!locale || locale.length !== 5) {
        return null
      }
      var pos = locale.indexOf("-");
      if(pos === -1) {
        pos = locale.indexOf("_")
      }
      var language = locale.substring(0, pos);
      var territory = locale.substring(pos + 1).toUpperCase();
      locale = language + "_" + territory;
      return locale
    }
    function getBrowserLocaleShortIso() {
      var locale = null;
      if(!navigator) {
        return null
      }
      locale = navigator.browserLanguage;
      if(!locale || locale.length < 2) {
        locale = navigator.language
      }
      if(!locale || locale.length < 2) {
        locale = navigator.userLanguage
      }
      if(!locale || locale.length < 2) {
        locale = navigator.systemLanguage
      }
      if(!locale || locale.length < 2) {
        return null
      }
      var pos = locale.indexOf("-");
      if(pos === -1) {
        pos = locale.indexOf("_")
      }
      if(pos > 0) {
        locale = locale.substring(0, pos)
      }
      if(locale !== null && locale.length === 2) {
        locale = locale.toLowerCase()
      }
      return locale
    }
    function getParameter(name, defaultValue) {
      var url = window.location.href;
      var pos = -1;
      var v = "";
      if((pos = url.indexOf(name + "=")) !== -1) {
        var pos2 = url.indexOf("#", pos);
        if(pos2 === -1) {
          pos2 = url.indexOf("&", pos)
        }
        if(pos2 === -1) {
          v = url.substr(pos + name.length + 1)
        }else {
          v = url.substr(pos + name.length + 1, pos2 - (pos + name.length + 1))
        }
      }
      if(v !== undefined && v !== "") {
        return decodeURIComponent(v)
      }
      return defaultValue
    }
    function createUrlParameterString(obj) {
      var buff = "", k = "";
      for(k in obj) {
        if(obj.hasOwnProperty(k)) {
          if(buff !== "") {
            buff += "&"
          }
          buff += k + "=" + encodeURIComponent(obj[k])
        }
      }
      return buff
    }
    function hasLocalStorageSupport() {
      if(window.localStorage) {
        return true
      }
      return false
    }
    function getGlobalHttpHeaders() {
      return _global_http_headers
    }
    function addGlobalHttpHeader(key, val) {
      _global_http_headers[key] = val
    }
    function ajax(options) {
      var ajaxOptions = {type:"GET", cache:false, headers:{}, data:{}, dataType:"json"};
      jQ.extend(ajaxOptions, options);
      jQ.extend(ajaxOptions.headers, _global_http_headers);
      jQ.extend(ajaxOptions.data, _global_http_parameters);
      var fixedOptionsObj = {beforeSend:function(jqXHR, settings) {
        jqXHR.url = settings.url
      }};
      jQ.extend(ajaxOptions, fixedOptionsObj);
      return jQ.ajax(ajaxOptions)
    }
    function ajaxPost(options, params) {
      return ajax(jQ.extend(options, {type:"POST"}))
    }
    function injectFiles(injectionFiles) {
      var def = jQ.Deferred();
      if(!injectionFiles) {
        def.resolve()
      }else {
        if(injectionFiles.files.length === 0) {
          def.resolve()
        }
        var i, cssFiles = [], cssSources = [], jsFiles = [];
        var file;
        for(i = 0;i < injectionFiles.files.length;++i) {
          file = injectionFiles.files[i];
          if(file.type === "style") {
            if(cssFiles.hasOwnProperty("path")) {
              cssFiles.push(file.path)
            }else {
              cssSources.push(file.src)
            }
          }else {
            if(file.type === "script") {
              jsFiles.push(file.path)
            }
          }
          file = null
        }
        var mandatoryFileCount = jsFiles.length, injectedFileCount = 0;
        if(mandatoryFileCount === 0) {
          def.resolve()
        }
        var win = function() {
          injectedFileCount++;
          if(injectedFileCount === mandatoryFileCount) {
            def.resolve()
          }
        };
        var fileref;
        for(i = 0;i < jsFiles.length;++i) {
          fileref = document.createElement("script");
          fileref.setAttribute("type", "text/javascript");
          fileref.setAttribute("src", jsFiles[i]);
          fileref.onload = win;
          document.getElementsByTagName("head")[0].appendChild(fileref)
        }
        var $head = jQ("head");
        for(i = 0;i < cssFiles.length;++i) {
          $head.append('<link rel="stylesheet" type="text/css" href="' + cssFiles[i] + '">')
        }
        for(i = 0;i < cssSources.length;++i) {
          $head.append('<style type="text/css">' + cssSources[i] + "</style>")
        }
        jsFiles.length = 0;
        cssFiles.length = 0;
        injectionFiles.files.length = 0;
        injectionFiles = null
      }
      return def
    }
    (function() {
      _languages.push({short_iso:"en", long_iso:"en_GB", language:"english", name:"English", country:"United Kingdom"});
      _languages.push({short_iso:"en", long_iso:"en_US", language:"english", name:"English", country:"United States"});
      _languages.push({short_iso:"de", long_iso:"de_DE", language:"german", name:"Deutsch", country:"Deutschland"});
      _languages.push({short_iso:"it", long_iso:"it_IT", language:"italian", name:"Italiano", country:"Italia"});
      _languages.push({short_iso:"fr", long_iso:"fr_FR", language:"french", name:"Fran\u00e7ais", country:"France"});
      _languages.push({short_iso:"es", long_iso:"es_ES", language:"spanish", name:"Espa\u00f1ol", country:"Espa\u00f1a"});
      _languages.push({short_iso:"ja", long_iso:"ja_JP", language:"japanese", name:"\u65e5\u672c\u8a9e", country:"\u65e5\u672c"});
      _languages.push({short_iso:"zh", long_iso:"zh_CN", language:"chinese", name:"\u4e2d\u6587\uff08\u7b80\u4f53\uff09", country:"\u4e2d\u56fd"});
      _languages.push({short_iso:"zh", long_iso:"zh_TW", language:"chinese_traditional", name:"\u4e2d\u6587\uff08\u50b3\u7d71\uff09", country:"\u4e2d\u56fd"});
      _languages.push({short_iso:"ru", long_iso:"ru_RU", language:"russian", name:"\u0440\u0443\u0441\u0441\u043a\u0438\u0439", country:"\u0420\u0443\u0441\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438"});
      _languages.push({short_iso:"ko", long_iso:"ko_KR", language:"korean", name:"\ud55c\uad6d\uc758", country:"\ud55c\uad6d"});
      _languages.push({short_iso:"pt", long_iso:"pt_PT", language:"portuguese", name:"Portugu\u00eas", country:"Portugal"});
      _languages.push({short_iso:"cs", long_iso:"cs_CZ", language:"czech", name:"\u010ce\u0161tina", country:"\u010cesk\u00e1 republika"});
      _languages.push({short_iso:"pl", long_iso:"pl_PL", language:"polish", name:"Polski", country:"Polska"});
      _languages.push({short_iso:"ro", long_iso:"ro_RO", language:"romanian", name:"Rom\u00e2n", country:"Rom\u00e2nia"});
      _languages.push({short_iso:"da", long_iso:"da_DK", language:"danish", name:"Dansk", country:"Danmark"});
      _languages.push({short_iso:"nl", long_iso:"nl_NL", language:"dutch", name:"Nederlands", country:"Nederland"});
      _languages.push({short_iso:"fi", long_iso:"fi_FL", language:"finnish", name:"Suomi", country:"Suomi"});
      _languages.push({short_iso:"hu", long_iso:"hu_HU", language:"hungarian", name:"Magyar", country:"Magyarorsz\u00e1g"});
      _languages.push({short_iso:"sk", long_iso:"sk_SK", language:"slovak", name:"Sloven\u010dina", country:"Slovensk\u00e1 republika"});
      _languages.push({short_iso:"sl", long_iso:"sl_SI", language:"slovenian", name:"Sloven\u0161\u010dina", country:"Republika Slovenija"});
      _languages.push({short_iso:"sv", long_iso:"sv_SE", language:"swedish", name:"Svenska", country:"Sverige"});
      _languages.push({short_iso:"tr", long_iso:"tr_TR", language:"turkish", name:"T\u00fcrk\u00e7e", country:"T\u00fcrkiye"});
      var languageObj = null;
      languageObj = getLanguageByLongIso(getBrowserLocaleLongIso());
      if(!languageObj) {
        languageObj = getLanguageByShortIso(getBrowserLocaleShortIso())
      }
      if(languageObj !== null) {
        _language = languageObj.language
      }
      if(hasLocalStorageSupport() && localStorage.language !== null) {
        var i;
        for(i = 0;i < _languages.length;++i) {
          if(_languages[i].language === localStorage.language) {
            _language = localStorage.language;
            break
          }
        }
      }
    })();
    return{getServiceBaseUrl:getServiceBaseUrl, setServiceBaseUrl:setServiceBaseUrl, getLanguage:getLanguage, setLanguage:setLanguage, getLanguageByShortIso:getLanguageByShortIso, getLanguageByLongIso:getLanguageByLongIso, getLanguageByLanguage:getLanguageByLanguage, getShortIsoByLanguage:getShortIsoByLanguage, getLongIsoByLanguage:getLongIsoByLanguage, getParameter:getParameter, createUrlParameterString:createUrlParameterString, hasLocalStorageSupport:hasLocalStorageSupport, getGlobalHttpHeaders:getGlobalHttpHeaders, 
    addGlobalHttpHeader:addGlobalHttpHeader, ajax:ajax, ajaxPost:ajaxPost, injectFiles:injectFiles}
  }()
})(window, jQuery);
(function(window, jQ) {
  var psol = window.psol = window.psol || {};
  psol.index = function() {
    var _tableServicePath = "/service/table", _indexServicePath = "/service/index", _midentServicePath = "/service/mident", _licenseServicePath = "/service/license";
    var _imageServicePath = "/FileService/CatalogImage";
    var _techViewServicePath = "/service/techviews";
    var _derivationViewServicePath = "/service/derivationviews";
    var _pregeneratedPreviewPath = "/23d-web";
    var _3dPreviewServicePath = "/service/preview3d";
    var _includeDocuments = false;
    function setIncludeDocuments(yesno) {
      _includeDocuments = yesno
    }
    function getNodeInfoAsync(params, options) {
      options = options || {};
      var ajaxOpts = {url:psol.core.getServiceBaseUrl() + _indexServicePath, cache:true, data:jQ.extend({type:"dir", response:"json", fast:"yes", language:params.language || psol.core.getLanguage(), path:params.path || "", includeDocs:params.includeDocuments || _includeDocuments ? 1 : 0}, params)};
      jQ.extend(ajaxOpts, options);
      return psol.core.ajax(ajaxOpts)
    }
    function getTableInfoAsync(params, options) {
      options = options || {};
      var ajaxOpts = {url:psol.core.getServiceBaseUrl() + _tableServicePath, data:jQ.extend({type:"tab", response:"json", fast:"yes", language:params.language || psol.core.getLanguage(), path:params.path || "", mident:params.mident || "", varsettransfer:params.varset || "", changevar:params.changeVarName || "", changeval:params.changeVarValue === undefined ? params.changeVarValue : ""}, params)};
      jQ.extend(ajaxOpts, options);
      return psol.core.ajaxPost(ajaxOpts)
    }
    function getMIdentAsync(params, options) {
      options = options || {};
      var ajaxOpts = {url:psol.core.getServiceBaseUrl() + _midentServicePath, dataType:"html", data:jQ.extend({type:"mident", path:"", maxlen:-1, language:psol.core.getLanguage(), varsettransfer:""}, params)};
      jQ.extend(ajaxOpts, options);
      return psol.core.ajaxPost(ajaxOpts)
    }
    function getTechViewsAsync(params, options) {
      options = options || {};
      var ajaxOpts = {url:psol.core.getServiceBaseUrl() + _techViewServicePath, data:jQ.extend({path:"", language:psol.core.getLanguage(), varsettransfer:"", mident:""}, params)};
      jQ.extend(ajaxOpts, options);
      return psol.core.ajaxPost(ajaxOpts)
    }
    function getDerivationViewsAsync(params, options) {
      options = options || {};
      var ajaxOpts = {url:psol.core.getServiceBaseUrl() + _derivationViewServicePath, data:jQ.extend({path:"", language:psol.core.getLanguage(), varsettransfer:"", mident:""}, params)};
      jQ.extend(ajaxOpts, options);
      return psol.core.ajaxPost(ajaxOpts)
    }
    function checkLicenseAsync(params, options) {
      options = options || {};
      var ajaxOpts = {url:psol.core.getServiceBaseUrl() + _licenseServicePath, data:jQ.extend({type:"license", lic_key:"", path:""}, params)};
      jQ.extend(ajaxOpts, options);
      return psol.core.ajaxPost(ajaxOpts)
    }
    function getPreviewImageUrl(path, image, options) {
      var parameters = {PreviewPath:image, width:100, height:100};
      jQ.extend(parameters, options);
      return psol.core.getServiceBaseUrl() + _imageServicePath + "?" + psol.core.createUrlParameterString(parameters)
    }
    function getPregeneratedPreviewUrl(path) {
      var p = path;
      p = p.replace(/\.prj$/i, ".gif");
      return psol.core.getServiceBaseUrl() + _pregeneratedPreviewPath + "/" + p
    }
    function get3dPreviewAsync(params, options) {
      options = options || {};
      var ajaxOpts = {url:psol.core.getServiceBaseUrl() + _3dPreviewServicePath, dataType:"", data:jQ.extend({varsettransfer:"", path:"", language:psol.core.getLanguage(), format:"", options:""}, params)};
      jQ.extend(ajaxOpts, options);
      return psol.core.ajaxPost(ajaxOpts)
    }
    (function() {
    })();
    return{setIncludeDocuments:setIncludeDocuments, getNodeInfoAsync:getNodeInfoAsync, getTableInfoAsync:getTableInfoAsync, getMIdentAsync:getMIdentAsync, getTechViewsAsync:getTechViewsAsync, getDerivationViewsAsync:getDerivationViewsAsync, getPreviewImageUrl:getPreviewImageUrl, checkLicenseAsync:checkLicenseAsync, getPregeneratedPreviewUrl:getPregeneratedPreviewUrl, get3dPreviewAsync:get3dPreviewAsync}
  }()
})(window, jQuery);
(function(window, jQ) {
  var psol = window.psol = window.psol || {};
  psol.search = function() {
    var _fullTextSearchServicePath = "/service/fulltextsearch";
    var _autoCompleteServicePath = "/service/auto-complete-v1";
    function startFullTextSearchAsync(options) {
      var parameters = {query:"", catalogs:"", offset:0, num:10, language:psol.core.getLanguage(), lines:0, pretty:0, pids:0, hl:0, hlpre:"", hlpost:""};
      jQ.extend(parameters, options);
      return psol.core.ajax({url:psol.core.getServiceBaseUrl() + _fullTextSearchServicePath, data:parameters})
    }
    function startAutoCompletionSearchAsync(options) {
      var parameters = {query:"", max:10, catalogs:"", language:psol.core.getLanguage()};
      jQ.extend(parameters, options);
      return psol.core.ajax({url:psol.core.getServiceBaseUrl() + _autoCompleteServicePath, data:parameters})
    }
    (function() {
    })();
    return{startFullTextSearchAsync:startFullTextSearchAsync, startAutoCompletionSearchAsync:startAutoCompletionSearchAsync}
  }()
})(window, jQuery);
(function(window, jQ) {
  var psol = window.psol || {};
  psol.translation = function() {
    var _translationServicePath = "/service/translation";
    var _translationMap = {};
    function getTranslationAsync(options) {
      return psol.core.ajax({url:psol.core.getServiceBaseUrl() + _translationServicePath, cache:true, data:jQ.extend({module:"", language:psol.core.getLanguage(), format:"json"}, options)}).done(function(data, textStatus, jqXHR) {
        jQ.extend(true, _translationMap, data)
      })
    }
    function getTranslationByUrlAsync(url) {
      return psol.core.ajax({url:url}).done(function(data, textStatus, jqXHR) {
        jQ.extend(true, _translationMap, data)
      })
    }
    function translate(text, args, language) {
      language = language || psol.core.getLanguage();
      var s = text;
      if(_translationMap[language] !== undefined && _translationMap[language][text] !== undefined) {
        s = _translationMap[language][text]
      }else {
        if(language !== "english" && language !== "german") {
          s = _translationMap.english ? _translationMap.english[text] || text : text
        }
      }
      if(args !== undefined) {
        var i;
        for(i = 0;i < args.length;++i) {
          s = s.replace("%" + (i + 1), args[i])
        }
      }
      return s
    }
    return{getTranslationAsync:getTranslationAsync, getTranslationByUrlAsync:getTranslationByUrlAsync, translate:translate, tr:translate, zTR:translate}
  }()
})(window, jQuery);
(function(window, jQ) {
  var psol = window.psol = window.psol || {};
  psol.exports = function() {
    var _exportServicePath = "/service/export";
    function getExportFileUrl(options) {
      var parameterString = psol.core.createUrlParameterString(jQ.extend({mident:"", varsettransfer:"", path:"", language:psol.core.getLanguage(), format:"", src:"", version:"", options:"", rt:"file"}, options));
      return psol.core.getServiceBaseUrl() + _exportServicePath + "?" + parameterString
    }
    function getExportFileUrlAsync(options) {
      return psol.core.ajaxPost({url:psol.core.getServiceBaseUrl() + _exportServicePath, data:jQ.extend({mident:"", varsettransfer:"", path:"", language:psol.core.getLanguage(), format:"", src:"", version:"", options:"", rt:"json"}, options)})
    }
    function getExportFileContentAsync(options) {
      return psol.core.ajaxPost({url:psol.core.getServiceBaseUrl() + _exportServicePath, dataType:"", data:jQ.extend({mident:"", varsettransfer:"", path:"", language:psol.core.getLanguage(), format:"", src:"", version:"", options:""}, options)})
    }
    (function() {
    })();
    return{getExportFileUrl:getExportFileUrl, getExportFileUrlAsync:getExportFileUrlAsync, getExportFileContentAsync:getExportFileContentAsync}
  }()
})(window, jQuery);
(function(window, jQ) {
  var psol = window.psol = window.psol || {};
  psol.order = function() {
    var _cgi2pviewServicePath = "/cgi-bin/cgi2pview.exe";
    var _cadFormatListXml = "/PARTcommunityManagement/FormatList";
    function orderAsync(part, email, format, cgiaction, options) {
      return psol.core.ajaxPost({url:psol.core.getServiceBaseUrl() + _cgi2pviewServicePath, dataType:"html", data:jQ.extend({part:part, email:email, format:format, cgiaction:cgiaction, ccode:"utf8", partcode:"utf8", language:psol.core.getLanguage()}, options)})
    }
    function getCadFormatListAsync(portal, opts) {
      var parameters = {};
      if(typeof portal != "undefined" && (portal != null && portal != "")) {
        jQ.extend(parameters, {portal:portal})
      }
      if(typeof opts !== "undefined" && opts !== null) {
        jQ.extend(parameters, opts)
      }
      return psol.core.ajax({url:psol.core.getServiceBaseUrl() + _cadFormatListXml, dataType:"xml", data:parameters})
    }
    function getCadFormatListAsJsonAsync(portal, opts) {
      var def = new jQ.Deferred;
      getCadFormatListAsync(portal, opts).done(function(xml) {
        var list = [];
        jQ(xml).find("format").each(function() {
          var visibleName = jQ(this).find("name").text();
          if(jQ(this).find("version").text() != "") {
            visibleName += " " + jQ(this).find("version").text()
          }
          visibleName += " " + jQ(this).attr("cad");
          list.push({name:jQ(this).find("name").text(), qualifier:jQ(this).find("qualifier").text(), version:jQ(this).find("version").text(), direct2cad:jQ(this).find("directintocad").text() == "true", cad:jQ(this).attr("cad"), visibleName:visibleName})
        });
        list.sort(function(a, b) {
          if(a.visibleName > b.visibleName) {
            return 1
          }else {
            if(a.visibleName < b.visibleName) {
              return-1
            }
          }
          return 0
        });
        def.resolve(list)
      }).fail(function(jqXHR, textStatus, errorThrown) {
        def.reject(jqXHR, textStatus, errorThrown)
      });
      return def.promise()
    }
    return{orderAsync:orderAsync, getCadFormatListAsync:getCadFormatListAsync, getCadFormatListAsJsonAsync:getCadFormatListAsJsonAsync}
  }()
})(window, jQuery);
(function(window, jQ) {
  var psol = window.psol = window.psol || {};
  psol.message = function() {
    var _windowForMessage, _defaultOrigin, _lastOrigin;
    _defaultOrigin = _lastOrigin = window.location.origin;
    function setMessageInterface(win) {
      _windowForMessage = win
    }
    function getOrigin() {
      return _lastOrigin
    }
    function messagingAvailable() {
      return _windowForMessage !== undefined
    }
    function postMessage(message, origin) {
      if(!origin) {
        origin = "*"
      }
      if(_lastOrigin !== origin) {
        _lastOrigin = origin
      }
      if(_windowForMessage) {
        try {
          _windowForMessage.postMessage(message, origin)
        }catch(e) {
          console.error(e.message)
        }
      }
    }
    return{setMessageInterface:setMessageInterface, messagingAvailable:messagingAvailable, getOrigin:getOrigin, postMessage:postMessage}
  }()
})(window, jQuery);
(function(window, jQ) {
  var psol = window.psol = window.psol || {};
  var _erpServiceURL = "/service/login", _userName = "", _userPass = "", _selectedGroup = "", _preferredRangeEnabled = false, _indexFilterEnabled = false, _sessionActive = false;
  psol.erp = function() {
    function doErpRequest(parameters) {
      var def = jQ.Deferred();
      getSessionAndTryReconnect().done(function() {
        var ajx = psol.core.ajax({url:psol.core.getServiceBaseUrl() + _erpServiceURL, data:parameters});
        ajx.done(function(data) {
          def.resolve(data)
        });
        ajx.fail(function() {
          def.reject()
        })
      }).fail(function() {
        def.reject()
      });
      return def.promise()
    }
    function setUserData(name, pass) {
      _userName = name;
      _userPass = pass
    }
    function login() {
      var def = jQ.Deferred();
      if(_userName.length === 0) {
        return def.reject("no username given")
      }
      var parameters = {cmd:"login", user:_userName, pwd:_userPass, language:psol.core.getLanguage()};
      var ajx = psol.core.ajax({url:psol.core.getServiceBaseUrl() + _erpServiceURL, data:parameters});
      ajx.done(function(data) {
        if(data.valid) {
          _sessionActive = true;
          def.resolve("successfully connected")
        }else {
          _sessionActive = false;
          def.reject("login data invalid")
        }
      });
      ajx.fail(function() {
        _sessionActive = false;
        def.reject("error with ajax request")
      });
      return def.promise()
    }
    function logout() {
      var def = jQ.Deferred();
      var parameters = {cmd:"logout"};
      doErpRequest(parameters).done(function(data) {
        _sessionActive = false;
        def.resolve()
      }).fail(function() {
        def.reject()
      });
      return def.promise()
    }
    function getSession() {
      var def = jQ.Deferred();
      var parameters = {cmd:"sessionValid"};
      var ajx = psol.core.ajax({url:psol.core.getServiceBaseUrl() + _erpServiceURL, data:parameters});
      ajx.done(function(data) {
        _sessionActive = data.valid;
        def.resolve(data.valid)
      }).fail(function(data) {
        _sessionActive = false;
        def.reject(false)
      });
      return def.promise()
    }
    function getSessionAndTryReconnect() {
      var def = jQ.Deferred();
      getSession().done(function(validSession) {
        if(validSession) {
          def.resolve()
        }else {
          login().done(function(validSession) {
            if(validSession) {
              def.resolve()
            }else {
              def.reject()
            }
          }).fail(function() {
            def.reject()
          })
        }
      }).fail(function() {
        def.reject()
      });
      return def.promise()
    }
    function getGroups() {
      var def = jQ.Deferred();
      var parameters = {cmd:"listGroups"};
      doErpRequest(parameters).done(function(data) {
        def.resolve(data)
      }).fail(function() {
        def.reject({})
      });
      return def.promise()
    }
    function selectGroup(name) {
      var def = jQ.Deferred();
      var parameters = {cmd:"selectGroup", groupName:name};
      _selectedGroup = name;
      doErpRequest(parameters).done(function(data) {
        def.resolve()
      }).fail(function() {
        def.reject()
      });
      return def.promise()
    }
    function applySettings(settings) {
      var def = jQ.Deferred();
      var parameters = {cmd:"settings"};
      jQ.extend(parameters, settings);
      doErpRequest(parameters).done(function(data) {
        def.resolve()
      }).fail(function() {
        def.reject()
      });
      return def.promise()
    }
    function setPreferredRangeEnabled(onOff) {
      var def = jQ.Deferred();
      var parameters = {prefRangeEnabled:onOff};
      applySettings(parameters).done(function(data) {
        def.resolve()
      }).fail(function() {
        def.reject()
      });
      return def.promise()
    }
    function setIndexFilterEnabled(onOff) {
      var def = jQ.Deferred();
      var parameters = {indexFilterEnabled:onOff};
      applySettings(parameters).done(function(data) {
        def.resolve()
      }).fail(function() {
        def.reject()
      });
      return def.promise()
    }
    function tryReconnect() {
      var def = jQ.Deferred();
      getSessionAndTryReconnect().done(function() {
        selectGroup(_selectedGroup).done(function() {
          def.resolve()
        }).fail(function() {
          def.reject()
        })
      }).fail(function() {
        def.reject()
      });
      return def.promise()
    }
    return{setUserData:setUserData, getGroups:getGroups, selectGroup:selectGroup, setPreferredRangeEnabled:setPreferredRangeEnabled, setIndexFilterEnabled:setIndexFilterEnabled, login:login, logout:logout, tryReconnect:tryReconnect}
  }()
})(window, jQuery);
(function(window, jQ) {
  var psol = window.psol = window.psol || {};
  psol.geoSearch = function() {
    var _geoSearchServicePath = "/service/geosearch";
    function startSketchSearchAsync(options) {
      var parameters = {top:"", side:"", front:"", catalogs:"", offset:0, num:10, language:psol.core.getLanguage(), lines:0, israw:false};
      jQ.extend(parameters, options);
      return psol.core.ajax({type:"POST", url:psol.core.getServiceBaseUrl() + _geoSearchServicePath + "/sketchsearch", data:parameters})
    }
    function getSearchTemplatesAsync() {
      return psol.core.ajax({url:psol.core.getServiceBaseUrl() + _geoSearchServicePath + "/templates"})
    }
    function startGeoSearchByFileAsync(options) {
      var parameters = {catalogs:"", offset:0, num:10, language:psol.core.getLanguage(), quality:90, details:false};
      jQ.extend(parameters, options);
      return psol.core.ajax({url:psol.core.getServiceBaseUrl() + _geoSearchServicePath + "/byfile", data:parameters})
    }
    function startGeoSearchByProjectAsync(options) {
      var parameters = {catalogs:"", offset:0, num:10, language:psol.core.getLanguage(), quality:90, details:false};
      jQ.extend(parameters, options);
      return psol.core.ajax({url:psol.core.getServiceBaseUrl() + _geoSearchServicePath + "/byproject", data:parameters})
    }
    (function() {
    })();
    return{startSketchSearchAsync:startSketchSearchAsync, getSearchTemplatesAsync:getSearchTemplatesAsync, startGeoSearchByFileAsync:startGeoSearchByFileAsync, startGeoSearchByProjectAsync:startGeoSearchByProjectAsync}
  }()
})(window, jQuery);
(function(window, jQ) {
  var psol = window.psol || {};
  psol.cloud = function() {
    var RESULT_ORDER = {NEWEST:"newest", MOST_LIKED:"most_liked", MOST_VIEWED:"most_viewed", MOST_DOWNLOADED:"most_downloaded"};
    var RESULT_ORDER_NAME_MAP = {NEWEST:"Newest", MOST_LIKED:"Most Liked", MOST_VIEWED:"Most Viewed", MOST_DOWNLOADED:"Most Downloaded"};
    var _exportUrl = "/service/external/partcloud/service/export";
    var _previewUrl = "/service/external/partcloud/service/preview3d";
    var _apiCall = function(controller, method, data) {
      var url = psol.core.getServiceBaseUrl() + "/service/external/partcloud/api.php";
      url += "?controller=" + controller;
      url += "&action=" + method;
      url += "&language=" + psol.core.getLanguage();
      return psol.core.ajaxPost({url:url, data:data})
    };
    var models = function() {
      var controller = "Models";
      function _get(options) {
        var defaults = {limit:10, offset:0, order:RESULT_ORDER.NEWEST, where_category:undefined, where_tag:undefined, where_user:undefined, where_liker:undefined, where_collection:undefined, where_geosearch:undefined, where_geosearchfile:undefined, user:false, tags:false, comments:false, images:false, likes:false};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "get", options)
      }
      function _getSingle(options) {
        var defaults = {model_id:undefined, user:false, tags:false, comments:false, images:false, likes:false};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "getSingle", options)
      }
      function _delete(options) {
        var defaults = {model_id:undefined};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "delete", options)
      }
      function _edit(options) {
        var defaults = {model_id:undefined, name:"", description:"", category_id:undefined};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "edit", options)
      }
      function _add(options) {
        var defaults = {category_id:undefined, name:"", description:"", file:undefined, license_id:undefined, remote_login:false, email:undefined, password:undefined};
        options = jQ.extend(defaults, options);
        options.file = options.file && options.file.files ? options.file.files[0] : [];
        var data = new FormData;
        data.append("controller", controller);
        data.append("action", "add");
        var key, val;
        for(key in options) {
          if(options.hasOwnProperty(key)) {
            val = options[key];
            if(val !== undefined) {
              data.append(key, val)
            }
          }
        }
        var def = jQ.Deferred();
        jQ.ajax({url:psol.core.getServiceBaseUrl() + "/service/external/partcloud/api.php", type:"POST", data:data, processData:false, contentType:false, dataType:"json", xhr:function() {
          var xhr = jQ.ajaxSettings.xhr();
          xhr.upload.onprogress = function(event) {
            def.notify(event)
          };
          return xhr
        }}).done(function(data) {
          def.resolve(data)
        }).fail(function(err) {
          def.reject(err)
        });
        return def.promise()
      }
      function _search(options) {
        var defaults = {query:"", limit:10, offset:0, order:RESULT_ORDER.NEWEST, user:false, tags:false, comments:false, images:false, likes:false, fulltext:false};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "search", options)
      }
      function _increaseDownloadCount(options) {
        var defaults = {model_id:undefined};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "increaseDownloadCount", options)
      }
      return{get:_get, getSingle:_getSingle, "delete":_delete, edit:_edit, add:_add, search:_search, increaseDownloadCount:_increaseDownloadCount}
    }();
    var images = function() {
      var controller = "Images";
      function _add(options) {
        var defaults = {model_id:undefined, made_id:undefined, description:"", file:undefined};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "add", options)
      }
      function _edit(options) {
        var defaults = {image_id:undefined, description:""};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "edit", options)
      }
      function _delete(options) {
        var defaults = {image_id:undefined};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "edit", options)
      }
      function _setPreview(options) {
        var defaults = {model_id:undefined, image_id:undefined};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "setPreview", options)
      }
      return{add:_add, edit:_edit, "delete":_delete, setPreview:_setPreview}
    }();
    var categories = function() {
      var controller = "Categories";
      function _get(options) {
        var defaults = {children:true};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "get", options)
      }
      function _getChildren(options) {
        var defaults = {category_id:undefined};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "getChildren", options)
      }
      return{get:_get, getChildren:_getChildren}
    }();
    var tags = function() {
      var controller = "Tags";
      function _get(options) {
        var defaults = {limit:10, offset:0, like:""};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "get", options)
      }
      function _add(options) {
        var defaults = {model_id:undefined, name:""};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "add", options)
      }
      function _remove(options) {
        var defaults = {model_id:undefined, tag_id:""};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "remove", options)
      }
      return{get:_get, add:_add, remove:_remove}
    }();
    var comments = function() {
      var controller = "Comments";
      function _get(options) {
        var defaults = {model_id:undefined, limit:10, offset:0};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "get", options)
      }
      function _getSingle(options) {
        var defaults = {comment_id:undefined};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "getSingle", options)
      }
      function _delete(options) {
        var defaults = {comment_id:undefined};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "delete", options)
      }
      function _edit(options) {
        var defaults = {comment_id:undefined, comment_text:""};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "edit", options)
      }
      function _add(options) {
        var defaults = {comment_id:undefined, comment_text:""};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "add", options)
      }
      return{get:_get, getSingle:_getSingle, "delete":_delete, edit:_edit, add:_add}
    }();
    var likes = function() {
      var controller = "Likes";
      function _get(options) {
        var defaults = {model_id:undefined, limit:10, offset:0};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "get", options)
      }
      function _like(options) {
        var defaults = {model_id:undefined};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "like", options)
      }
      return{get:_get, like:_like}
    }();
    var collections = function() {
      var controller = "Collections";
      function _get(options) {
        var defaults = {limit:10, offset:0, order:RESULT_ORDER.NEWEST, where_user:undefined, user:false, models:false};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "get", options)
      }
      function _getSingle(options) {
        var defaults = {collection_id:undefined, user:false, models:false};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "getSingle", options)
      }
      function _addModel(options) {
        var defaults = {collection_id:undefined, model_id:undefined};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "addModel", options)
      }
      function _removeModel(options) {
        var defaults = {model_id:undefined};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "removeModel", options)
      }
      function _add(options) {
        var defaults = {name:"", description:""};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "add", options)
      }
      function _edit(options) {
        var defaults = {collection_id:undefined, name:"", description:""};
        options = jQ.extend(defaults, options);
        return _apiCall(controller, "edit", options)
      }
      return{get:_get, getSingle:_getSingle, addModel:_addModel, removeModel:_removeModel, add:_add, edit:_edit}
    }();
    var mades = function() {
      var controller = "Mades";
      return{}
    }();
    var users = function() {
      var controller = "Users";
      function _loginStatus() {
        return _apiCall(controller, "loginstatus")
      }
      return{loginStatus:_loginStatus}
    }();
    var project = function() {
      var _exportFormats = {formats:[{format:"STL", description:"STL 3D"}, {format:"STL_REDUCED", description:"STL (reduced)"}, {format:"CREOVIEW", description:"Creo view"}, {format:"3DSASCII", description:"3d Studio Max ASCII"}, {format:"BYUFILE", description:"Movie Surface Geometry"}, {format:"HRCFILE", description:"Softimage Hierarchy"}, {format:"IVFILE", description:"SGI Open Inventor"}, {format:"OBJFILE", description:"OBJ (WaveFront)"}, {format:"TECFILE", description:"TecPlot"}, {format:"UCDFILE", 
      description:"AVS UCD File"}, {format:"VLAFILE", description:"VLA File"}, {format:"XGLFILE", description:"XML/OpenGL Format"}]};
      function _getExportFormats() {
        return jQ.Deferred().resolve(_exportFormats)
      }
      return{getExportFormats:_getExportFormats}
    }();
    var licenses = function() {
      var controller = "Licenses";
      function _get() {
        return _apiCall(controller, "get")
      }
      return{get:_get}
    }();
    var configurations = function() {
      var controller = "Configurations";
      function _get() {
        return _apiCall(controller, "get")
      }
      return{get:_get}
    }();
    var _exportAsync = function(data, options) {
      options = options || {};
      var ajaxOpts = {url:psol.core.getServiceBaseUrl() + _exportUrl, dataType:"", data:jQ.extend({varsettransfer:"", path:"", language:psol.core.getLanguage(), format:"", options:""}, data)};
      jQ.extend(ajaxOpts, options);
      return psol.core.ajaxPost(ajaxOpts)
    };
    var _getPreviewAsync = function(data, options) {
      options = options || {};
      var ajaxOpts = {url:psol.core.getServiceBaseUrl() + _previewUrl, dataType:"", data:jQ.extend({varsettransfer:"", path:"", language:psol.core.getLanguage(), format:"", options:""}, data)};
      jQ.extend(ajaxOpts, options);
      return psol.core.ajaxPost(ajaxOpts)
    };
    return{models:models, images:images, categories:categories, tags:tags, comments:comments, likes:likes, collections:collections, mades:mades, users:users, project:project, licenses:licenses, configurations:configurations, RESULT_ORDER:RESULT_ORDER, RESULT_ORDER_NAME_MAP:RESULT_ORDER_NAME_MAP, exportAsync:_exportAsync, getPreviewAsync:_getPreviewAsync}
  }()
})(window, jQuery);
(function(window, jQ) {
  var psol = window.psol = window.psol || {};
  psol.pins = function() {
    function addpin(params, options) {
      options = options || {};
      var ajaxOpts = {url:psol.core.getServiceBaseUrl() + "/service/external/pins/addpin", data:jQ.extend({name:undefined, description:undefined, imagepath:undefined, image_base64:undefined, linkpath:undefined, boardname:undefined, prepend_name:undefined, append_name:undefined, noactivity:undefined, email:undefined, password:undefined, use_canonical_url:false, language:psol.core.getLanguage()}, params)};
      jQ.extend(ajaxOpts, options);
      return psol.core.ajaxPost(ajaxOpts)
    }
    function getpinboard(params, options) {
      options = options || {};
      var ajaxOpts = {url:psol.core.getServiceBaseUrl() + "/service/external/pins/getpinboard", data:jQ.extend({boardname:undefined, user_id:undefined, board_id:undefined, prepend_name:undefined, use_canonical_url:false, language:psol.core.getLanguage()}, params)};
      jQ.extend(ajaxOpts, options);
      return psol.core.ajaxPost(ajaxOpts)
    }
    return{addpin:addpin, getpinboard:getpinboard}
  }()
})(window, jQuery);
window.psol = window.psol || {};
(function() {
  psol.Color = function(color) {
    this._r = 0;
    this._g = 0;
    this._b = 0;
    this._a = 0;
    if(arguments.length === 3 || arguments.length === 4) {
      return this.setRGBA.apply(this, arguments)
    }
    return this.setStyle(color)
  };
  psol.Color.constructor = psol.Color;
  psol.Color.prototype.setStyle = function(color) {
    if(color.match(/^rgb/)) {
      color = color.match(/rgb\(([^)]+)\)/)[1];
      color = color.split(/ *, */).map(Number);
      this._r = color[0];
      this._g = color[1];
      this._b = color[2]
    }else {
      if(color[0] === "#" && color.length === 7) {
        this._r = parseInt(color.slice(1, 3), 16);
        this._g = parseInt(color.slice(3, 5), 16);
        this._b = parseInt(color.slice(5, 7), 16);
        this._a = 255
      }else {
        if(color[0] === "#" && color.length === 4) {
          this._r = parseInt(color[1] + color[1], 16);
          this._g = parseInt(color[2] + color[2], 16);
          this._b = parseInt(color[3] + color[3], 16);
          this._a = 255
        }else {
          if(color.length === 8) {
            this._a = parseInt(color.slice(0, 2), 16);
            this._r = parseInt(color.slice(2, 4), 16);
            this._g = parseInt(color.slice(4, 6), 16);
            this._b = parseInt(color.slice(6, 8), 16)
          }
        }
      }
    }
    return this
  };
  psol.Color.prototype.setRGBA = function(r, g, b, a) {
    this._r = r;
    this._g = g;
    this._b = b;
    this._a = a || 255;
    return this
  };
  psol.Color.prototype.brightness = function() {
    return(this._r * 299 + this._g * 587 + this._b * 114) / 1E3
  };
  psol.Color.prototype.getHTML = function() {
    return"#" + (this._r << 16 ^ this._g << 8 ^ this._b << 0).toString(16)
  };
  psol.Color.prototype.getRGB = function() {
    return"rgb(" + this._r + "," + this._g + "," + this._b + ")"
  };
  psol.Color.prototype.getRGBA = function() {
    return"rgba(" + this._r + "," + this._g + "," + this._b + "," + this._a / 255 + ")"
  }
})(jQuery);

