/*jslint browser: true, plusplus: true, white: true, nomen: true, regexp: true */
/*global jQuery, psol */

(function ($) {
  'use strict';

  /**
   * @todo jQuery selectors on the view (faster)
   * @todo optimze jQuery selectors (save as variable) for better performance
   */

  /**
   * filterAssistant component
   * @class
   * @memberof psol.components
   * @extends psol.components.ViewBase
   * @example

    // create an filterAssistant component
    var filterAssistant = new psol.components.filterAssistant();

    // settings for the component
    var settings = {
      container: $('.componentContainer'),
      useRetinaImages: false
    };

    // initialize the component with the settings
    filterAssistant.init(settings);

    // show the component
    filterAssistant.show().done(function () {
      // load a path to the index
      filterAssistant.loadByPath('/23d-libs/filter.prj');
    }

   */
  psol.components.FilterAssistant = function () {
    var self = this;

    psol.components.ViewBase.call(this, 'FilterAssistant');
    this._props.path = '';
    this._props.isV9 = false;
    this._props.useRetinaImages = false;
    this._props.tableData = {};
    this._props.search = {
      multiOriginVars: {},
      lists: {},
      ranges: {}
    };
    this._props.jsrenderHelpers = {
      getStep: function(step, prec) {
        return step === 0 ? Math.pow(10, -prec) : step;
      },
      getStep2: function(minMax) {
        var matchMin = minMax[0].toString().match(/\.\d+/),
            matchMax = minMax[1].toString().match(/\.\d+/),
            precMin = 0, precMax = 0;

        if ( matchMin ) {
          precMin = matchMin[0].length - 1;
        }
        if ( matchMax ) {
          precMax = matchMax[0].length - 1;
        }
        return precMin >= precMax ? Math.pow(10, -precMin) : Math.pow(10, -precMax);
      },
      translate: function(arg, varName) {
        var lang = psol.core.getLanguage();

        if ( typeof(arg) === 'string' ) {
          return psol.translation.tr(arg);
        } else {
          if ( arg[lang] ) {
            return arg[lang] !== '' ? arg[lang] + ' [' + varName + ']' : varName;
          } else {
            return arg.english || varName;
          }
        }
      },
      getImagePath: function(img) {
        var pos = self._props.path.search(/[^\/]*\.prj/),
            path = self._props.path.substr(0, pos);

        if ( self._props.isV9 ) {
          return '/23d-libs/' + img;
        }

        return '/23d-libs' + img.replace(path, '');
      }
    };
  };

  // inheritance
  psol.components.FilterAssistant.prototype = Object.create(psol.components.ViewBase.prototype);
  psol.components.FilterAssistant.constructor = psol.components.FilterAssistant;


  psol.components.FilterAssistant.prototype._onSearchClicked = function (event) {
    event.data = this.getSearchObj();
    this.onSearchClicked.call(event, event);
  };


  psol.components.FilterAssistant.prototype._onResetClicked = function (event) {
    event.data = this._props.path;
    this.onResetClicked.call(event, event);
  };


  psol.components.FilterAssistant.prototype._onTechViewNavClicked = function(event) {
    var $btn = $(event.currentTarget),
        action = $btn.data('action'),
        $img = $btn.prevAll('.FilterAssistantTechviewImg'),
        views = $img.data('views'),
        idx = parseInt($img.data('idx'), 10);

    if ( action === 'next' ) {
      idx += 1;
      if ( idx === views.length ) {
        idx = 0;
      }
    } else {
      idx -= 1;
      if ( idx === -1 ) {
        idx = views.length - 1;
      }
    }

    $img.attr('src', views[idx]);
    $img.data('idx', idx);
  };


  psol.components.FilterAssistant.prototype._getSortedValues = function(values) {
    var temp = [],
        val;

    for ( val in values ) {
      if ( values.hasOwnProperty(val) ) {
        try {
          values[val].current = JSON.parse(values[val].current);
        } catch(e) {}
        temp.push($.extend({}, values[val], {name: val}));
      }
    }

    temp.sort(function(a, b) {
      if ( a.order > b.order ) {
        return 1;
      } else if ( a.order < b.order ) {
        return -1;
      }
      return 0;
    });

    return temp;
  };


  psol.components.FilterAssistant.prototype._insertTechViews = function(techviews) {
    var views = [],
        $techViewsContainer = $('.FilterAssistantTechviewsContainer'),
        i;

    $techViewsContainer.empty();

    if ( techviews.error || !techviews.views ) {
      this.resizeContainer();
    } else {
      for ( i = 0; i < techviews.views.length; i++ ) {
        views.push(techviews.views[i].dataUrl);
      }
      $techViewsContainer.html(this._render('tmpl-FilterAssistantTechviews', {view: views[0], length: views.length}))
      $('.FilterAssistantTechviewImg').on('load', this.resizeContainer);
      $('.FilterAssistantTechviewImg').data('views', views);
    }
  };


  psol.components.FilterAssistant.prototype._renderAssistant = function(index, techviews) {
    $('.FilterAssistantHeader').html(this._render('tmpl-FilterAssistantHeader', index));

    var sortedValues = this._getSortedValues(index.line.values),
        $scrollContainer = $('.FilterAssistantScrollContainer'),
        i;

    $scrollContainer.empty();

    this._props.search.searchQuery = index.line.values.SEARCHQUERY.current;
    this._props.search.catalogs = index.line.values.SEARCHPATH.current.split(',');

    if ( index.line.values.CNSVERSION ) {
      for ( i = 0; i < sortedValues.length; i++ ) {
        if ( typeof(sortedValues[i].current) === 'string' ) {
          $scrollContainer.append(this._render('tmpl-FilterAssistantTableItemV9', sortedValues[i]));
        } else {
          this._props.search.multiOriginVars[sortedValues[i].name] = sortedValues[i].current;
          $scrollContainer.append(this._render('tmpl-FilterAssistantTableItem', sortedValues[i].current));
        }
      }
    } else {
      this._props.isV9 = true;
      $scrollContainer.html(this._render('tmpl-FilterAssistantTableItemV9', sortedValues));
    }

    $('.FilterAssistantSlider').ionRangeSlider({type: 'double', grid: true, hide_min_max: true, hide_from_to: true});
    $('#selectAll_CNS_CATALOG').trigger('click');

    this._insertTechViews(techviews);
  };


  psol.components.FilterAssistant.prototype._viewPostDisplay = function() {
    var dfd = $.Deferred(),
        self = this;

    psol.translation.getTranslationByUrlAsync('translation/translate.json').always(function () {
      $('.FilterAssistantFooter').html(self._render('tmpl-FilterAssistantFooter'));
      dfd.resolve();
    });

    return dfd;
  };


  psol.components.FilterAssistant.prototype._viewEvents = function () {
    var self = this;
    return {
      'click; .FilterAssistantSearch': function(event) {
        psol.components.FilterAssistant.prototype._onSearchClicked.call(self, event);
      },

      'click; .FilterAssistantReset': function(event) {
        psol.components.FilterAssistant.prototype._onResetClicked.call(self, event);
      },

      'click; .FilterAssistantTechviewImgBtn': function(event) {
        psol.components.FilterAssistant.prototype._onTechViewNavClicked(event);
      },

      'change; .FilterAssistantSlider': function(event) {
        var $slider = $(event.currentTarget),
            value = [$slider.data('from'), $slider.data('to')],
            id = $slider.data('slider-id'),
            prec = 0,
            match = $slider.data('step').toString().match(/\.\d+/),
            range;

        if ( match ) {
          prec = match[0].length - 1;
        }

        $('#sliderMin_' + id).val(value[0].toFixed(prec));
        $('#sliderMax_' + id).val(value[1].toFixed(prec));

        self._props.search.ranges[id] = {};
        range = self._props.search.ranges[id];

        if ( $('#sliderMin_' + id).val() !== $slider.data('min').toFixed(prec) ) {
          range.min = $('#sliderMin_' + id).val();
        } else {
          range.min = null;
        }

        if ( $('#sliderMax_' + id).val() !== $slider.data('max').toFixed(prec) ) {
          range.max = $('#sliderMax_' + id).val();
        } else {
          range.max = null;
        }
      },

      'blur; .FilterAssistantSliderInput': function(event) {
        var $inputMin = $(event.currentTarget),
            id = $inputMin.attr('id'),
            sliderId = $inputMin.data('sliderid'),
            slider = $('.FilterAssistantSlider[data-slider-id="' + sliderId + '"]').data('ionRangeSlider'),
            $inputMax, values = [];

        if ( id.search('sliderMin') > -1 ) {
          $inputMax = $('#sliderMax_' + sliderId);
        } else {
          $inputMax = $inputMin;
          $inputMin = $('#sliderMin_' + sliderId);
        }

        slider.update({from: $inputMin.val().replace(',', '.'), to: $inputMax.val().replace(',', '.')});
      },

      'keydown; .FilterAssistantSliderInput': function(event) {
        if ( event.keyCode === 13 ) {
          $(event.currentTarget).trigger('blur');
        }
      },

      'change; .FilterAssistantSelectAllCheckbox': function(event) {
        var $selectAll = $(event.currentTarget),
            id = $selectAll.data('attr'),
            $checkboxes = $('.FilterAssistantListCheckbox[data-attr="' + id + '"]'),
            list, i;

        if ( $selectAll.prop('checked') ) {
          $checkboxes.prop('checked', true);
        } else {
          $checkboxes.prop('checked', false);
        }

        self._props.search.lists[id] = {
          values: [],
          operator: $('.FilterAssistantAndOr[data-attr="' + id + '"]').val() || 'OR'
        };

        list = self._props.search.lists[id];

        $checkboxes = $checkboxes.parent().find('input:checked');
        for ( i = 0; i < $checkboxes.length; i++ ) {
          list.values.push($checkboxes.get(i).value);
        }
      },

      'change; .FilterAssistantListCheckbox': function(event) {
        var id = $(event.currentTarget).data('attr'),
            $checkboxes = $('.FilterAssistantListCheckbox[data-attr="' + id + '"]:checked'),
            list, i;

        self._props.search.lists[id] = {
          values: [],
          operator: $('.FilterAssistantAndOr[data-attr="' + id + '"]').val() || 'OR'
        };

        list = self._props.search.lists[id];

        for ( i = 0; i < $checkboxes.length; i++ ) {
          list.values.push($checkboxes.get(i).value);
        }
      },

      'change; .FilterAssistantAndOr': function(event) {
        var $select = $(event.currentTarget),
            id = $select.data('attr');

        if ( self._props.search.lists[id] ) {
          self._props.search.lists[id].operator = $select.val() || 'OR';
        }
      }
    };
  };


  // callbacks
  /**
   * Callback when search is clicked. The FilterAssistant implementation does nothing.
   * @param {Object} event The event.indexNode contains the clicked index node
   */

  /*eslint-disable no-unused-vars*/
  psol.components.FilterAssistant.prototype.onSearchClicked = function (event) {
    /* default: do noting here */
    return;
  };
  /*eslint-enable no-unused-vars*/

  /**
   * Callback when reset is clicked. The FilterAssistant implementation does nothing.
   * @param {Object} event The event.indexNode contains the clicked index node
   */

  /*eslint-disable no-unused-vars*/
  psol.components.FilterAssistant.prototype.onResetClicked = function (event) {
    /* default: do noting here */
    return;
  };
  /*eslint-enable no-unused-vars*/


  /**
   * Initialize the component
   * @param   {Object}  settings                         The settings for this component
   * @param   {Object}  settings.container               The container jQuery DOM object
   * @param   {Boolean} [settings.useRetinaImages=false] Use retina images
   */
  psol.components.FilterAssistant.prototype.init = function (settings) {
    psol.components.ViewBase.prototype.init.call(this, settings);
  };


  // public methods
  /**
   * Load index nodes from path into the container
   * @param   {String}          path The index path
   * @returns {jQuery.Deferred} A {@link http://api.jquery.com/category/deferred-object/ jQuery.Deferred} object, which resolves when the index nodes are rendered
   */
  psol.components.FilterAssistant.prototype.loadByPath = function (path) {
    var self = this,
        def = $.Deferred(),
        progressTitle = psol.translation.zTR('Bitte warten...'),
        progressText = psol.translation.zTR('Index wird geladen...'),
        language = window.location.search.match(/language=[^&]*/);

    this._props.path = path;
    if ( language ) {
      psol.core.setLanguage(language[0].split('=')[1]);
      //psol.core.setLanguage('english');
    }

    self.onProgressBegin(progressTitle, progressText).done(function (progressCustomObject) {
      psol.index.getTableInfoAsync({
        path: path,
        showall: true,
        showma: true,
        showerp: false
      }).done(function (data) {
        var index = data.index;
        if ( index && index.line ) {
          psol.index.getTechViewsAsync({path: path}).done(function(techviews) {
            self._props.path = index.path;
            self._props.tableData = index;
            self._renderAssistant(index, techviews);
            def.resolve();
          });
        } else {
          def.reject();
        }
        self.onProgressEnd(progressCustomObject);
      }).fail(function () {
        $('.FilterAssistantScrollContainer').html('Tabelle konnte nicht geladen werden.');
        def.reject();
        self.onProgressEnd(progressCustomObject);
      });
    });

    return def.promise();
  };


  /**
   * Load contents of this index node into the container
   * @param   {Object}          node Index node object
   * @returns {jQuery.Deferred} A {@link http://api.jquery.com/category/deferred-object/ jQuery.Deferred} object, which resolves when the index nodes are rendered
   */
  psol.components.FilterAssistant.prototype.loadByIndexNode = function (node) {
    var path = node.path;
    return this.loadByPath(path);
  };


  /**
   * Call this when resize the container
   */
  psol.components.FilterAssistant.prototype.resizeContainer = function () {
    psol.components.ViewBase.prototype.resizeContainer.call(this);

    var $tabItems = $('.FilterAssistantTableItem'),
        itemsHeight = 0,
        availableSpace = $(window).innerHeight() - (24 + $('.FilterAssistantHeader').outerHeight(true) + $('.FilterAssistantFooter').outerHeight(true) + $('.FilterAssistantTechviews').outerHeight(true));

    $tabItems.each(function(idx, item) {
      itemsHeight += $(item).outerHeight(true);
    });

    if ( itemsHeight > availableSpace ) {
      $('.FilterAssistantScrollContainer').height(availableSpace);
    } else {
      $('.FilterAssistantScrollContainer').height(itemsHeight);
    }
  };


  /**
   * Returns the current loaded path
   * @returns {String} The path
   */
  psol.components.FilterAssistant.prototype.getPath = function () {
    return this._props.path;
  };


  /**
   * Returns the current search string
   * @returns {String} The search string
   */
  psol.components.FilterAssistant.prototype.getSearchObj = function(callback) {
    var ranges = this._props.search.ranges,
        lists = this._props.search.lists,
        multiOrigin = this._props.search.multiOriginVars,
        searchObj = {
          query: this._props.search.searchQuery,
          paths: ''
        },
        range, list, i, j, variables, temp, temp2;

    if ( lists ) {
      for ( list in lists ) {
        if ( lists.hasOwnProperty(list) ) {
          if ( lists[list].values.length > 0 ) {
            if ( list === 'CNS_CATALOG' ) {
              searchObj.paths = lists[list].values.join(',');
            } else if ( list === 'CNS_NN' || list === 'CNS_NT' ) {
              searchObj.query += ' AND ("' + lists[list].values.join('" ' + lists[list].operator + ' "') + '")';
            } else {
              if ( multiOrigin[list] ) {
                variables = multiOrigin[list].variables;
                temp2 = [];
                for ( i = 0; i < lists[list].values.length; i++ ) {
                  temp = [];
                  for ( j = 0; j < variables.length; j++ ) {
                    temp.push('(catalog="' + variables[j].catname + '" AND ' + variables[j].varname + ' = "' + lists[list].values[i] + '")');
                  }
                  temp2.push('(' + temp.join(' OR ') + ')');
                }
                searchObj.query += ' AND (' + temp2.join(' ' + lists[list].operator + ' ') + ')';
              } else {
                searchObj.query += ' AND (' + list + ' = "' + lists[list].values.join('" ' + lists[list].operator + ' ' + list + ' = "') + '")';
              }
            }
          }
        }
      }
    }

    if ( ranges ) {
      for ( range in ranges ) {
        if ( ranges.hasOwnProperty(range) ) {
          if ( ranges[range].min ) {
            if ( multiOrigin[range] ) {
              variables = multiOrigin[range].variables;
              temp = [];
              for ( i = 0; i < variables.length; i++ ) {
                temp.push('(catalog="' + variables[i].catname + '" AND ' + variables[i].varname + ' >= ' + ranges[range].min + ')');
              }
              searchObj.query += ' AND (' + temp.join(' OR ') + ')';
            } else {
              searchObj.query += ' AND (' + range + ' >= ' + ranges[range].min + ')';
            }
          }
          if ( ranges[range].max ) {
            if ( multiOrigin[range] ) {
              variables = multiOrigin[range].variables;
              temp = [];
              for ( i = 0; i < variables.length; i++ ) {
                temp.push('(catalog="' + variables[i].catname + '" AND ' + variables[i].varname + ' <= ' + ranges[range].max + ')');
              }
              searchObj.query += ' AND (' + temp.join(' OR ') + ')';
            } else {
              searchObj.query += ' AND (' + range + ' <= ' + ranges[range].max + ')';
            }
          }
        }
      }
    }

    if ( searchObj.paths === '' ) {
      searchObj.paths = this._props.tableData.line.values.SEARCHPATH.current;
    }

    if ( callback ) {
      callback(searchObj);
    }

    return searchObj;
  };


}(jQuery));
