/*jslint browser: true, node: true, nomen: true, vars: true, devel: true, indent: 2 */
/*global brite, $, psol, render, main, refreshTable, getSortedColumns, createSlider */


/**
 * @author psteeger
 */

(function () {
  'use strict';
  var _view;
  brite.registerView('table_view', {

    create: function (data) {
      return render('tmpl-table_view');
    },

    postDisplay: function () {
      _view = this;

      var line = main.tableData.index.line;
      if (parseInt(line.nr, 10) !== -1) {
        refreshTable.call(_view, line);
      }
    },

    events: {
      // Slider events
      'blur; .table_view-slider-inputTd >input': function (event) {
        var id = $(event.currentTarget).bEntity('Slider').id;
        var value = parseFloat($('#sliderVal_' + id).val());

        if (parseFloat(main.tableData.index.line.values[id].current) !== value) {
          this.$el.trigger('TABLE_VALUE_CHANGE', {
            changeVar: id,
            changeValue: value
          });
        }
      },

      'keyup; .table_view-slider-inputTd >input': function (event) {
        var $target = $(event.currentTarget),
          value = $target.val().replace(/,/, '.'),
          sliderData = $('#slider_' + $target.bEntity('Slider').id).slider().data('slider');

        if (isNaN(value)) {
          if (!(sliderData.min < 0 && value.length === 1 && value === '-')) {
            $target.val(value.substring(0, value.length - 1));
          }
        }
      },

      'slide; .table_view-slider-sliderTd >div': function (event) {
        var id = $(event.currentTarget).bEntity('Slider').id;
        var $slider = $('#slider_' + id);
        var value = $slider.slider().data('slider').getValue();
        var $inputField = $('#sliderVal_' + id).val(parseFloat(value.toFixed(5)));
      },

      'slideStop; .table_view-slider-sliderTd >div': function (event) {
        var targetId = $(event.currentTarget).bEntity('Slider').id;
        $('#sliderVal_' + targetId).trigger('blur');
      }
    }
  });


  // ---------- PRIVATE METHODS ---------- //

  function dropDownSelected(data) {
    console.log(data);
    var id = data.attr('id');
    var value = data.find('option:selected').val();
    _view.$el.trigger('TABLE_VALUE_CHANGE', {
      changeVar: id,
      changeValue: value
    });
  }

  function refreshTable(line) {
    var sortedColumns = getSortedColumns(line.values);
    var searchFound = false;
    var even = true;

    $.each(sortedColumns, function (idx, column) {
      if (column.name === 'SEARCH') {
        searchFound = true;
      }

      if (!column.isHidden) {
        $.extend(column, {
          even: even
        });

        if (!searchFound) {
          if ((column.status === '') || (column.status === 'static') || (column.status === 'fixed') || (column.status === 'finished')) {
            if (column.values && column.values.length > 1) {
              // build selectmenu

              _view.$el.append(render('tmpl-table_view-dropdown', $.extend(column, {
                imgBasePath: main.tableData.index.imgbasepath + '?previewPath='
              })));
            } else {
              // build textbox
              if (column.current !== '') {
                _view.$el.append(render('tmpl-table_view-textbox', column));
              }
            }
          } else if (column.status === 'ranged') {
            // build slider
            createSlider(_view, column);
          }
        } else {
          var table = _view.$el.find('.table_view-infobox-table');
          if (!table.length) {
            table = _view.$el.append(render('tmpl-table_view-infobox', {
              even: even
            })).find('.table_view-infobox-table');
          }
          table.append(render('tmpl-table_view-infoboxItem', column));
        }
        even = !even;
      }
    });
    $('select').each(function () {
      $(this).psolDropDown({
        onSelected: dropDownSelected
      });
    });
    _view.$el.parent().scrollTop(main.tableScroll);
  }


  function createSlider(viewObj, column) {
    var view = viewObj;

    if (column.step === 0) {
      if (!column.prec) {
        column.prec = 3;
      }
      column.step = 1 / Math.pow(10, column.prec);
    }
    if (column.mininc && column.mininc === false) {
      column.min += column.step;
    }
    if (column.maxinc && column.maxinc === false) {
      column.max -= column.step;
    }

    view.$el.append(render('tmpl-table_view-slider', column));

    var $slider = $('#slider_' + column.name);
    $slider.slider();
  }

  function sortByOrderNr(obja, objb) {
    if (obja.order === objb.order) {
      return 0;
    } else if (obja.order > objb.order) {
      return 1;
    }
    return -1;
  }


  function getSortedColumns(columns) {
    var sortedColumns = [];
    var resultCols = [];

    var i;
    for (i in columns) {
      if (columns.hasOwnProperty(i)) {
        columns[i].name = i;
        if (columns[i].isResult) {
          resultCols.push(columns[i]);
        } else {
          sortedColumns.push(columns[i]);
        }
      }
    }

    sortedColumns.sort(sortByOrderNr);
    $.merge(sortedColumns, resultCols);


    return sortedColumns;
  }

}());