/*jslint browser: true, plusplus: true */
/*global brite $ */
'use strict';

/**
 * @author psteeger
 */


(function() {

  brite.registerView('main_view', {emptyParent: true} , {

    create: function(data) {
      //return render('tmpl-main_view', {title: data.title, subtitle: data.subtitle});
      return render('tmpl-main_view');
    },

    postDisplay: function() {
      var view = this;

      main.getTableData().done(function(data) {
        main.tableData = data;
        $('.main_view-header').html(render('tmpl-main_view-header', {title: data.index.NN, subtitle: data.index.NT}));

        brite.display('table_view', $('.main_view-table'));
        brite.display('techviews_view', $('.main_view-techview'));
      });
    },

    events: {
      'click; .main_view-search >button': function(event) {
        var columns = main.tableData.index.line.values;
        submitSearch(columns.SEARCHPATH.current, columns.SEARCH.current);
      }
    },

    docEvents: {
      'TABLE_VALUE_CHANGE': function(event, changeData) {
        var view = this;

        main.getTableData(changeData).done(function(data) {
          main.tableData = data;
          var table = view.$el.find('.main_view-table').bEmpty();
          brite.display('table_view', table);
        });
      },

      'HIDE_TECHVIEW': function(event) {
        $('.main_view-techview').hide();
      }
    },

    winEvents: {
      'resize': function(event) {
        var tableHeight = 0;
        var padding = $('.main_view').innerHeight() - $('.main_view').height();
        if ( main.hasTechviews )
          tableHeight = window.innerHeight - ($('.main_view-header').outerHeight(true) + $('.main_view-techview').outerHeight(true) + $('.main_view-search').outerHeight(true) + padding);
        else
          tableHeight = window.innerHeight - ($('.main_view-header').outerHeight(true)  + $('.main_view-search').outerHeight(true) + padding);
        $('.main_view-table').outerHeight(tableHeight, true);
      }
    }
  });

})();