/*jslint browser: true, node: true, nomen: true, vars: true, devel: true, indent: 2 */
/*global brite, $, psol */


/**
 * @author psteeger
 */

brite.viewDefaultConfig.loadTmpl = true;
brite.viewDefaultConfig.loadCss = true;

function render(templateName, data) {
  "use strict";
  var tmpTmplName = templateName;
  if (/Android|webOS|iPhone|iPad|iPod|BlackBerry/i.test(navigator.userAgent)) {
    tmpTmplName += '_mobile';
    if ($('#' + tmpTmplName).length === 0) {
      tmpTmplName = templateName;
    }
  }
  var tmpl = $.templates[tmpTmplName];
  if (!tmpl) {
    $.templates(tmpTmplName, '#' + tmpTmplName);
    tmpl = $.templates[tmpTmplName];
  }

  return tmpl.render(data);
}


$.views.helpers({
  zTr: function zTr(value) {
    "use strict";
    return psol.translation.translate(value, [], psol.core.getLanguage());
  }
});



var main = main || {};

(function () {
  "use strict";
  main.getParameterByName = function (paramName) {
    var match = new RegExp(paramName + '=([^&]*)').exec(window.location.search);
    return match && decodeURIComponent(match[1].replace(/\+/g, ' '));
  };

  main.isMobile = function () {
    if (/Android|webOS|iPhone|iPad|iPod|BlackBerry/i.test(navigator.userAgent)) {
      return true;
    }
    return false;
  };


  main.getTableData = function (changeData) {
    var changeVar = null;
    var changeValue = null;

    if (changeData) {
      changeVar = changeData.changeVar;
      changeValue = changeData.changeValue;
    }

    var varsetTransfer = null;
    if (main.tableData.index) {
      varsetTransfer = main.tableData.index.varsettransfer;
    }

    main.tableScroll = $('.main_view-table').scrollTop();

    return $.ajax({
      url: main.TABLE_SERVICE,
      type: 'POST',
      dataType: 'json',
      data: {
        path: main.prjPath,
        language: main.language,
        varsettransfer: varsetTransfer,
        changevar: changeVar,
        changeval: changeValue,
        showall: true,
        showma: true,
        showerp: false
      }
    });
  };


  main.TABLE_SERVICE = '/service/table';
  console.warn('!!!!/service/search only temporary until JUST fixes his pappserver - change to psol API');
  main.SEARCH_URL = '/service/search';

  main.language = main.getParameterByName('language');
  main.prjPath = main.getParameterByName('prj');
  main.tableData = {};
  main.hasTechviews = true;
  main.tableScroll = 0;

  main.init = function () {
    psol.ui.setUITemplateBaseFolder('tmpl/');
    psol.ui.initialize().done(function () {
      psol.translation.getTranslationByUrlAsync('translation/translate.json').always(function () {
        brite.display('main_view', '#pageBody');
      });
    });
  };

}());


$(document).ready(function () {
  "use strict";
  main.init();
});