<?xml version="1.0" encoding="windows-1251"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output encoding="windows-1251" method="html"/>
  <xsl:include href="transformCommon.xsl"/>

  <!-- stuff -->
  <xsl:variable name="EXPAND_ALL"></xsl:variable>
  <xsl:variable name="S_SHOW"></xsl:variable>
  <xsl:variable name="S_HIDE"></xsl:variable>

  <!-- like GENERAL_INFO_GROUP but without alignment -->
  <xsl:template match="/" name="FILE_INFO">
    <xsl:if test="*!=0">
      <table width="100%" class="table_block_1">
        <a href="#" class="toggle">
          <tr onclick="toggle('general_info', 'link_general_info', '1');return false;">
            <td class="td_header">
              Property
            </td>
            <td class="td_header">
              Value
            </td>
            <xsl:call-template name="TD_COLLAPSED">
                <xsl:with-param name="link_id" select="'link_general_info'"/>
                <xsl:with-param name="expand" select="$EXPAND_ALL"/>
            </xsl:call-template>
          </tr>
        </a>
        <tbody id="general_info">
          <xsl:if test="@*!=0">
            <tr>
              <xsl:for-each select="@*">
                <td>
                  <xsl:value-of select="."/>
                </td>
              </xsl:for-each>
            </tr>
          </xsl:if>
          <xsl:for-each select="*">
            <xsl:variable name="tdClass">
                <xsl:call-template name="LINE_CLASS_BY_POS">
                    <xsl:with-param name="mode" select="1"/>
                </xsl:call-template>
            </xsl:variable>
            <xsl:if test="name()!='Group'">
              <tr class="tr_hover">
                <xsl:for-each select="@*">
                  <td class="{$tdClass}">
                    <xsl:if test="position()=last()">
                      <xsl:attribute name="colspan">2</xsl:attribute>
                    </xsl:if>
                    <xsl:value-of select="."/>
                    <xsl:text disable-output-escaping="yes"><![CDATA[&nbsp;]]></xsl:text>
                  </td>
                </xsl:for-each>
              </tr>
            </xsl:if>
          </xsl:for-each>
        </tbody>
      </table>
    </xsl:if>
  </xsl:template>
  
  <xsl:template name="COL_ALIGN_RIGHT">
        <xsl:if test="name()='Count' or name()='Loaded' or name()='Skipped'">
          <xsl:attribute name="style">text-align: right;</xsl:attribute>
        </xsl:if>
    </xsl:template>
  
  <xsl:template name="SUMMARY">
    <table width ="100%" class="table_block_1">
      <a href="#" class="toggle">
        <tr onclick="toggle('loaded_objects', 'link_loaded_objects', '1');return false;">
          <td class="td_header">
            Name
          </td>
          <td class="td_header">
            Special Name
          </td>
          <td class="td_header">
            <div class="number">
              Count
            </div>
          </td>
          <td class="td_header">
            <div class="number">
              Loaded
            </div>
          </td>
          <td class="td_header" style="text-align: right;">
            <div class="number">
              Skipped
            </div>
          </td>
          <xsl:call-template name="TD_COLLAPSED">
              <xsl:with-param name="link_id" select="'link_loaded_objects'"/>
              <xsl:with-param name="expand" select="$EXPAND_ALL"/>
          </xsl:call-template>
        </tr>
      </a>
      <!-- select every sub group inside summary-->

      <tbody id="loaded_objects">
        <!-- select every entity-->
        <xsl:if test="count(Geometry) != 0">
          <tr class="tr_hover">
            <td colspan="6" class="td_dark">
              <strong> Geometry </strong>
            </td>
          </tr>
          <xsl:for-each select="Geometry">
            <xsl:sort data-type ="number" order="ascending" select="@Order"/>
            <xsl:variable name="tdClass">
              <xsl:call-template name="LINE_CLASS_BY_POS"></xsl:call-template>
            </xsl:variable>
            <tr class="tr_hover">
              <xsl:for-each select="@*">
                <xsl:if test="name()!='Order'">
                  <td class="{$tdClass}">
                    <xsl:call-template name="COL_ALIGN_RIGHT"></xsl:call-template>
                    <xsl:value-of select="."/>
                  </td>
                </xsl:if>
              </xsl:for-each>
              <td class="{$tdClass}"/>
            </tr>
          </xsl:for-each>
        </xsl:if>

        <xsl:if test="count(Topology) != 0">
          <tr class="tr_hover">
            <td colspan="6" class="td_dark_top_border">
              <strong> Topology </strong>
            </td>
          </tr>
          <xsl:for-each select="Topology">
            <xsl:sort data-type ="number" order="descending" select="@Order"/>
            <xsl:variable name="tdClass">
              <xsl:call-template name="LINE_CLASS_BY_POS"></xsl:call-template>
            </xsl:variable>
            <tr class="tr_hover">
              <xsl:for-each select="@*">
                <xsl:if test="name()!='Order'">
                  <td class="{$tdClass}">
                    <xsl:call-template name="COL_ALIGN_RIGHT"></xsl:call-template>
                    <xsl:value-of select="."/>
                  </td>
                </xsl:if>
              </xsl:for-each>
              <td class="{$tdClass}"/>
            </tr>
          </xsl:for-each>
        </xsl:if>

        <xsl:if test="count(ModelStructure) != 0">
          <tr class="tr_hover">
            <td colspan="6" class="td_dark_top_border">
              <strong> Model Structure </strong>
            </td>
          </tr>
          <xsl:for-each select="ModelStructure">
            <xsl:sort data-type ="number" order="ascending" select="@Order"/>
            <xsl:variable name="tdClass">
              <xsl:call-template name="LINE_CLASS_BY_POS"></xsl:call-template>
            </xsl:variable>
            <!-- for SPATIAL -->
            <xsl:choose>
              <xsl:when test="@SpecialName='PartInstance'">
                <tr class="tr_hover">
                  <xsl:for-each select="@*">
                    <xsl:if test="name()!='Order'">
                      <td class="{$tdClass}">
                        <xsl:call-template name="COL_ALIGN_RIGHT"></xsl:call-template>
                        <xsl:value-of select="."/>
                        <xsl:if test="name()='SpecialName'">
                          <xsl:for-each select="//PartInstanceName">
                            <br/>
                            &#160;&#160;&#160;<xsl:value-of select="@SpecialName"/>
                            (<xsl:value-of select="@Count"/>)
                          </xsl:for-each>
                        </xsl:if>
                      </td>
                    </xsl:if>
                  </xsl:for-each>
                  <td class="{$tdClass}"/>
                </tr>
              </xsl:when>
              <xsl:when test="@SpecialName='AssemblyInstance'">
                <tr class="tr_hover">
                  <xsl:for-each select="@*">
                    <xsl:if test="name()!='Order'">
                      <td class="{$tdClass}">
                        <xsl:call-template name="COL_ALIGN_RIGHT"></xsl:call-template>
                        <xsl:value-of select="."/>
                        <xsl:if test="name()='SpecialName'">
                          <xsl:for-each select="//AssemblyInstanceName">
                            <br/>
                            &#160;&#160;&#160;<xsl:value-of select="@SpecialName"/>
                            (<xsl:value-of select="@Count"/>)
                          </xsl:for-each>
                        </xsl:if>
                      </td>
                    </xsl:if>
                  </xsl:for-each>
                  <td class="{$tdClass}"/>
                </tr>
              </xsl:when>
              <xsl:otherwise>
                <tr class="tr_hover">
                  <xsl:for-each select="@*">
                    <xsl:if test="name()!='Order'">
                      <td class="{$tdClass}">
                        <xsl:call-template name="COL_ALIGN_RIGHT"></xsl:call-template>
                        <xsl:value-of select="."/>
                      </td>
                    </xsl:if>
                  </xsl:for-each>
                  <td class="{$tdClass}"/>
                </tr>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:for-each>
        </xsl:if>

        <xsl:if test="count(PMI) != 0">
          <tr class="tr_hover">
            <td colspan="6" class="td_dark_top_border">
              <strong> Annotations </strong>
            </td>
          </tr>
          <xsl:for-each select="PMI">
            <xsl:sort data-type ="number" order="ascending" select="@Order"/>
            <xsl:variable name="tdClass">
              <xsl:call-template name="LINE_CLASS_BY_POS"></xsl:call-template>
            </xsl:variable>
            <tr class="tr_hover">
              <xsl:for-each select="@*">
                <xsl:if test="name()!='Order'">
                  <td class="{$tdClass}">
                    <xsl:call-template name="COL_ALIGN_RIGHT"></xsl:call-template>
                    <xsl:value-of select="."/>
                  </td>
                </xsl:if>
              </xsl:for-each>
              <td class="{$tdClass}"/>
            </tr>
          </xsl:for-each>
        </xsl:if>

        <xsl:if test="count(Other) != 0">
          <tr class="tr_hover">
            <td colspan="6" class="td_dark_top_border">
              <strong> Others </strong>
            </td>
          </tr>
          <xsl:for-each select="Other">
            <xsl:sort data-type ="number" order="descending" select="@Count"/>
            <xsl:variable name="tdClass">
              <xsl:call-template name="LINE_CLASS_BY_POS"></xsl:call-template>
            </xsl:variable>
            <tr class="tr_hover">
              <xsl:for-each select="@*">
                <xsl:if test="name()!='Order'">
                  <td class="{$tdClass}">
                    <xsl:call-template name="COL_ALIGN_RIGHT"></xsl:call-template>
                    <xsl:value-of select="."/>
                  </td>
                </xsl:if>
              </xsl:for-each>
              <td class="{$tdClass}"/>
            </tr>
          </xsl:for-each>
        </xsl:if>
      </tbody>
    </table>

    <xsl:for-each select="//Comment">
      <xsl:value-of select="."/>
      <br/>
    </xsl:for-each>
    <br/>
    <br/>
    <br/>
  </xsl:template>

  <xsl:template match="/">
    <html>
      <head>
        <meta http-equiv="X-UA-Compatible" content="IE=8"/>
        <xsl:call-template name="COMMON_CSS"></xsl:call-template>
        <xsl:call-template name="COMMON_SCRIPT">
            <xsl:with-param name="s_hide" select="$S_HIDE"></xsl:with-param>
            <xsl:with-param name="s_show" select="$S_SHOW"></xsl:with-param>
        </xsl:call-template>
      </head>
      <body>
        <h4>
          <p>
            <strong>
              General information
            </strong>
          </p>
        </h4>
        <xsl:for-each select="//Group">
            <xsl:call-template name="FILE_INFO"></xsl:call-template>
        </xsl:for-each>

        <xsl:if test="count(//Summary/*) != 0">
          <!-- skip if summary is empty-->
          <h4>
            <p>
              <strong>
                Loaded objects
              </strong>
            </p>
          </h4>
          <xsl:for-each select="//Summary">
            <xsl:call-template name="SUMMARY"></xsl:call-template>
          </xsl:for-each>
        </xsl:if>
 
        <p>3DTransVidia</p>
        <p>Capvidia NV</p>
        <p>Technologielaan 3</p>
        <p>3001 Leuven, Belgium</p>
        <p>Tel: +3216402747</p>
        <p>Fax: +3216403271</p>
        <p>
          e-mail:<a href="mailto:info@capvidia.be">info@capvidia.be</a>
        </p>
        <p>
          <a href="http:\\www.capvidia.be">http:\\www.capvidia.be</a>
        </p>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>
